﻿
function checkOrderStatus(form) {
	var order_id_or_email = form.find(".order_id-or-email").val(),
        result = form.find(".result");
    
    $.ajax({
        type: "GET",
        url: 'index.php?route=extension/module/check_order_status/get_status',
        data: {
            "order_id_or_email" : order_id_or_email,
        },
        dataType: 'json',
        success: function(json) {  
            if(json) {
                // Some validation error
                if(json.error) {
                    result.addClass("alert text-danger").html(json.error);
                    result.delay(3000).fadeOut();

                // Show orders statuses
                } else {
                    var total_orders = json.orders.length,
                        current_order_number = 1;
                    
                    result.append(json.text.information_about_orders);
					
                    // Print info about orders
                    $.each(json.orders, function (index, order) {
                        var order_info = "<div class='order'>";
						
						// Load main info about order
                        order_info += order.info

                        // Add split line if here more than 1 orders
                        if (total_orders > 1 && current_order_number != total_orders) {
                            order_info += "<span class='order-split-line'/>"
                        }

                        order_info += "</div>";

                        result.append(order_info);
                        current_order_number++;
                    });
                }
            }
		},
        beforeSend: function() {
            result.html("").removeClass("alert text-danger").show();
        },
    });
}