<?php
class ModelExtensionModuleCheckOrderStatus extends Model
{
    public function orders_statuses($order_id_or_email_or_phone)
    {
        $sql = "SELECT o.order_id, os.name as order_status, o.date_added, oh.comment as history_comment";
        $sql .= " FROM `" . DB_PREFIX . "order` o";
        $sql .= " LEFT JOIN `" . DB_PREFIX . "order_status` os ON o.order_status_id=os.order_status_id";
        $sql .= " LEFT JOIN `" . DB_PREFIX . "order_history` oh ON oh.order_history_id = (
                    SELECT oh.order_history_id
                    FROM `" . DB_PREFIX . "order_history` oh
                    WHERE oh.order_id=o.order_id AND oh.order_status_id=o.order_status_id
                    ORDER BY oh.date_added
                    LIMIT 1
                  )";
        // Conditions for the whole query
        $sql .= " WHERE ";

        /* Search only by params which specified in module settings in the admin panel */
        $search_params = array();
        $settings      = $this->config->get('check_order_status_general_settings');

        if (isset($settings["search_by_order_id"])) {
            $search_params[] = "o.order_id = '" . (int) $order_id_or_email_or_phone . "'";
        }

        if (isset($settings["search_by_email"])) {
            $search_params[] = "o.email = '" . $this->db->escape($order_id_or_email_or_phone) . "'";
        }

        if (isset($settings["search_by_phone_number"])) {
            $search_params[] = "o.telephone = '" . $this->db->escape($order_id_or_email_or_phone) . "'";
        }

        if (!empty($search_params)) {
            $sql .= sprintf(" (%s) ", implode(" OR ", $search_params));
            $sql .= " AND ";
        }
        // $sql .= " (o.order_id = '" . (int) $order_id_or_email_or_phone . "' OR o.email = '" . $this->db->escape($order_id_or_email_or_phone) . "' OR o.telephone = '" . $this->db->escape($order_id_or_email_or_phone) . "') ";

        // Take into account user language (for order status)
        $sql .= " os.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        // Sort by date creation
        $sql .= " ORDER BY date_added DESC ";

        // If no parameters were selected by which user can search
        if (count($search_params) == 0) {
            $sql .= " LIMIT 0 ";
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
