<?php

class ControllerExtensionModuleCheckOrderStatus extends Controller
{
    private $module_name = "extension/module/check_order_status";

    static $module; # module number
    static $total_buttons_and_invisible; # number of total modules of types "invisible" or "button"

    public function index($setting)
    {
        $this->language->load($this->module_name);
        $data = $this->language->data;

        $this->document->addScript('catalog/view/javascript/check_order_status/main.js');
        $this->document->addStyle('catalog/view/javascript/check_order_status/main.css');

        $data["module"] = (int)$this->module;
        $this->module++;

        if ($setting["module_type"] == "button" || $setting["module_type"] == "invisible") {
            $this->total_buttons_and_invisible++;
        }

        # Loading General Settings
        $general_settings = $this->config->get('check_order_status_general_settings');
        $seach_params = array();

        if (!empty($general_settings)) {
            foreach ($general_settings as $key => $value) {
                $$key = $value;
            }
        }

        // Text for label "you can search by params"
        if (isset($search_by_order_id)) {
            $seach_params[] = $this->language->get("text_order_id");
        }

        if (isset($search_by_email)) {
            $seach_params[] = $this->language->get("text_email");
        }

        if (isset($search_by_phone_number)) {
            $seach_params[] = $this->language->get("text_phone_number");
        }

        $data["label_search_by"] = implode(", ", $seach_params);
        $data["text_enter_info"] = sprintf($this->language->get("enter_info"), implode($this->language->get("or"), $seach_params));

        /**
         * Module type can be one of the following:
         * 1) Block (visible)
         * 2) Button (visible)
         * 3) Invisible (to call pop-up window in any place on the store)
         *(Html pop-up window will be loaded only once)
         **/
        $data["type"] = $setting["module_type"];
        $data["total_buttons_and_invisible"] = (int)$this->total_buttons_and_invisible;

        return $this->load->view('extension/module/check_order_status', $data);
    }

    public function get_status()
    {
        $json = array();

        $this->language->load('extension/module/check_order_status');
        $this->load->model('extension/module/check_order_status');

        # Loading General Settings
        $general_settings = $this->config->get('check_order_status_general_settings');
        if (!empty($general_settings)) {
            foreach ($general_settings as $key => $value) {
                $$key = $value;
                // $data[$key] = $value;
            }
        }

        // Add translations
        $json["text"] = array(
            "information_about_orders" => $this->language->get("information_about_orders"),
        );

        $order_id_or_email_or_phone = isset($this->request->get["order_id_or_email"]) ? $this->request->get["order_id_or_email"] : null;

        if ($order_id_or_email_or_phone) {
            $orders = $this->model_extension_module_check_order_status->orders_statuses($order_id_or_email_or_phone);

            // Return orders with order_id, order status, and date_added
            if ($orders) {
                $orders_to_show = array();

                // Rewrite date_added without time
                foreach ($orders as $key => $order) {
                    $order_info = "";

                    if (isset($display_order_id)) {
                        $order_info .= sprintf($this->language->get("order_id"), $order["order_id"]);
                    }

                    if (isset($display_order_status)) {
                        $order_info .= sprintf($this->language->get("order_status"), $order["order_status"]);
                    }

                    if (isset($display_date_added)) {
                        $order_info .= sprintf($this->language->get("order_date_added"),
                            date($this->language->get('date_format_short'), strtotime($order['date_added'])));
                    }

                    // For empty comments we show dash "-"
                    if ($order['history_comment'] == "") {
                        $order['history_comment'] = "-";
                    }

                    if (isset($display_comment)) {
                        $order_info .= sprintf($this->language->get("order_comment"), $order['history_comment']);
                    }

                    $orders_to_show[]["info"] = $order_info;
                    // $orders[$key]["date_added"] = date($this->language->get('date_format_short'), strtotime($order['date_added']));
                }

                $json['orders'] = $orders_to_show;

                // No orders with such order_id or email
            } else {
                $json['error'] = $this->language->get('error_not_found');
            }
        } else {
            $json['error'] = $this->language->get('error_empty_field');
        }

        $this->response->setOutput(json_encode($json));
    }

}
