<?php
class ModelExtensionModuleBulkPrice extends Controller {
	public function getProducts($data, $preview = false) {
		$sql = "SELECT DISTINCT p.product_id, p.price";

		if ($preview) {
			$sql .= ", pd.name";
		}

		$sql .= " FROM " . DB_PREFIX . "product p";

		if ($preview) {
			$sql .= " LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";
		}

		if ($data['product_type'] == 'category' || !empty($data['both'])) {
			$sql .= " LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id)";
		}

		$condition = array();

		if ($data['product_type'] == 'category' || !empty($data['both'])) {
			$implode = array();

			foreach ($data['category'] as $category_id) {
				$implode[] = "p2c.category_id = '" . (int)$category_id . "'";
			}

			if ($implode) {
				$condition[] = " (" . implode(" OR ", $implode) . ")";
			}
		}

		if ($data['product_type'] == 'manufacturer' || !empty($data['both'])) {
			$implode = array();

			foreach ($data['manufacturer'] as $manufacturer_id) {
				$implode[] = "p.manufacturer_id = '" . (int)$manufacturer_id . "'";
			}

			if ($implode) {
				$condition[] = " (" . implode(" OR ", $implode) . ")";
			}
		}

		if ($data['product_type'] == 'product') {
			$implode = array();

			foreach ($data['product'] as $product_id) {
				$implode[] = "p.product_id = '" . (int)$product_id . "'";
			}

			if ($implode) {
				$condition[] = " (" . implode(" OR ", $implode) . ")";
			}
		}

		if ($preview) {
			$condition[] = " pd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		}

		if ($condition) {
			$sql .= " WHERE" . implode(" AND", $condition);
		}


		if ($preview) {
			$sql .= " ORDER BY pd.name ASC";
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function preview($data) {
		return $this->getProducts($data, true);
	}

	public function price($data) {
		$products = $this->getProducts($data);

		$applied = array();
		$ignored = array();

		$update_value = $data['update_value'];

		foreach ($products as $product) {
			if ($data['sign'] == '=') {
				$price = $data['update_value'];
			} else {
				if ($data['update_type'] == 'P') {
					$update_value = $product['price'] / 100 * $data['update_value'];
				}

				if ($data['sign'] == '+') {
					$price = $product['price'] + $update_value;
				}

				if ($data['sign'] == '-') {
					$price = $product['price'] - $update_value;
				}

				if ($data['sign'] == '*') {
					$price = $product['price'] * $update_value;
				}

				if ($data['sign'] == '/') {
					$price = $product['price'] / $update_value;
				}
			}

			if ($price < 0) {
				$ignored[] = $product['product_id'];

				continue;
			}

			$this->db->query("UPDATE " . DB_PREFIX . "product SET price = '" . (float)$price . "' WHERE product_id = '" . (int)$product['product_id'] . "'");

			$applied[] = $product['product_id'];
		}

		return array(
			'applied' => $applied,
			'ignored' => $ignored
		);
	}

	public function special($data) {
		$products = $this->getProducts($data);

		if (!empty($data['delete_existing'])) {
			$delete_data = $data;

			unset($delete_data['priority']);

			$this->delete($delete_data);
		}

		$applied = array();
		$ignored = array();

		$update_value = $data['update_value'];

		foreach ($products as $product) {
			if ($data['sign'] == '=') {
				$price = $data['update_value'];
			} else {
				if ($data['update_type'] == 'P') {
					$update_value = $product['price'] / 100 * $data['update_value'];
				}

				if ($data['sign'] == '+') {
					$price = $product['price'] + $update_value;
				}

				if ($data['sign'] == '-') {
					$price = $product['price'] - $update_value;
				}

				if ($data['sign'] == '*') {
					$price = $product['price'] * $update_value;
				}

				if ($data['sign'] == '/') {
					$price = $product['price'] / $update_value;
				}
			}

			if (!empty($data['ignore']) && ($product['price'] < $price || $price <= 0)) {
				$ignored[] = $product['product_id'];

				continue;
			}

			foreach ($data['customer_group'] as $customer_group_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int)$product['product_id'] . "', customer_group_id = '" . (int)$customer_group_id . "', priority = '" . (int)$data['priority'] . "', price = '" . (float)$price . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "'");
			}

			$applied[] = $product['product_id'];
		}

		return array(
			'applied' => $applied,
			'ignored' => $ignored
		);
	}

	public function delete($data) {
		$products = array();

		if ($data['product_type'] != 'all') {
			$products = $this->getProducts($data);
		}

		$sql = "DELETE FROM " . DB_PREFIX . "product_special";

		$condition = array();

		if ($products) {
			$implode = array();

			foreach ($products as $product) {
				$implode[] = (int)$product['product_id'];
			}

			if ($implode) {
				$condition[] = " product_id IN (" . implode(", ", $implode) . ")";
			}
		}

		if (!empty($data['customer_group'])) {
			$implode = array();

			foreach ($data['customer_group'] as $customer_group_id) {
				$implode[] = "customer_group_id = '" . (int)$customer_group_id . "'";
			}

			if ($implode) {
				$condition[] = " (" . implode(" OR ", $implode) . ")";
			}
		}

		if (isset($data['priority']) && is_numeric($data['priority'])) {
			$condition[] = " priority = '" . (int)$data['priority'] . "'";
		}

		if ($condition) {
			$sql .= " WHERE" . implode(" AND", $condition);
		}

		$this->db->query($sql);
	}
}