<?php

/*
 *******************************************************************************
 *  Module: Check order status
 *
 *  Web-site: http://opencart-modules.com
 *  Email: dev.dashko@gmail.com
 *  Leonid Dashko
 *
 *  Below source-code or any part of the source-code cannot be resold or distributed.
 ******************************************************************************
 */

include_once DIR_SYSTEM . 'library/opencart_modules/ModuleName.class.php';

final class ControllerExtensionModuleCheckOrderStatus extends Controller
{
    private $module_name = 'extension/module/check_order_status';

    public function __construct($registry)
    {
        parent::__construct($registry);

        $this->load->model('setting/setting');
        $this->load->model('setting/module');
        $this->load->model('localisation/language');

        $this->load->language('design/layout');
        $this->load->model('design/layout');

        $this->load->language('extension/module/check_order_status');
        $this->load->model("extension/module/check_order_status");
    }

    public function install()
    {
        if (!$this->validate()) die("Action is not permitted");

        $settings = array('display_order_id', 'display_order_status', 'display_date_added', 'display_comment', 'search_by_order_id', 'search_by_email', 'search_by_phone_number');
        $settings = array_fill_keys($settings, 1);

        $this->model_setting_setting->editSetting('check_order_status', array(
            'check_order_status_general_settings' => $settings,
        ));
    }

    public function index()
    {
        $data = $this->language->data;
        $data['module_name'] = ModuleName::CHECK_ORDER_STATUS;
        $data['lang'] = trim($this->config->get('config_admin_language'));

        $this->document->setTitle(str_replace(array("<b>", "</b>"), "", $this->language->get('heading_title')));

        $module_id = isset($this->request->get['module_id']) ? (int)$this->request->get['module_id'] : 0;

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            if ($module_id) {
                $this->model_setting_module->editModule($module_id, $this->request->post);

            } else {
                // Get newly created module_id
                $this->model_setting_module->addModule('check_order_status', $this->request->post);
                $module_id = $this->db->getLastID();
            }

            // Re-save existing layouts modules which are connected to this module
            $this->model_extension_module_check_order_status->save_layouts($module_id, $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->buildUrl($this->module_name, array('module_id' => $module_id)));
        }

        $data['languages'] = $this->model_localisation_language->getLanguages();
        $data['site_language'] = $this->config->get('config_language');

        # Show Success msgs
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        # Show Errors msgs
        if (isset($this->session->data['errors'])) {
            $data['errors'] = $this->session->data['errors'];
            unset($this->session->data['errors']);
        } else {
            $data['errors'] = array();
        }

        $module_info = array();
        if ($module_id && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $module_info = $this->model_setting_module->getModule($this->request->get['module_id']);
        }

        $data['module_types'] = array(
            "block" => $this->language->get("type_block"),
            "button" => $this->language->get("type_button"),
            "invisible" => $this->language->get("type_invisible"),
        );

        #######################
        // Prepare info for filling text fields
        if (isset($this->request->post['name'])) {
            $data['name'] = $this->request->post['name'];
        } elseif (!empty($module_info)) {
            $data['name'] = $module_info['name'];
        } else {
            $data['name'] = '';
        }

        if (isset($this->request->post['module_type'])) {
            $data['module_type'] = $this->request->post['module_type'];
        } elseif (!empty($module_info)) {
            $data['module_type'] = $module_info['module_type'];
        } else {
            $data['module_type'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($module_info)) {
            $data['status'] = $module_info['status'];
        } else {
            $data['status'] = '';
        }

        # Loading General Settings
        $general_settings = $this->config->get('check_order_status_general_settings');
        if (!empty($general_settings)) {
            foreach ($general_settings as $key => $value) {
                $data[$key] = $value;
                // $data['general_settings'][$key] = $value;
            }
        }

        if (isset($this->request->post['layout_module'])) {
            $data['connected_layouts'] = $this->request->post['layout_module'];
        } else {
            $data['connected_layouts'] = $this->model_extension_module_check_order_status->getConnectedLayouts($module_id);
        }

        $data['layouts'] = $this->model_design_layout->getLayouts();
        $data['breadcrumbs'] = $this->getBreadcrumbs();

        if ($module_id) {
            $data['url_save'] = $this->buildUrl($this->module_name, array('module_id' => (int)$this->request->get['module_id']));
        } else {
            $data['url_save'] = $this->buildUrl($this->module_name);
        }

        $data['url_save_settings'] = $this->buildUrl($this->module_name . '/ajaxSaveGeneralSettings');
        $data['url_cancel'] = $this->getUrlToModulesPage();
        $data['link_to_support'] = 'https://opencart-modules.com/tab-modules?lang=' . trim($this->config->get('config_admin_language'));

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->load->language($this->module_name);

        $this->response->setOutput($this->load->view($this->module_name, $data));
    }

    private function getBreadcrumbs()
    {
        $breadcrumbs = array();
        $breadcrumbs[] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->buildUrl('common/dashboard'),
        );
        $breadcrumbs[] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->getUrlToModulesPage(),
        );
        $breadcrumbs[] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->buildUrl($this->module_name),
        );
        return $breadcrumbs;
    }

    private function getUrlToModulesPage()
    {
        if (version_compare(VERSION, '2.3.0.0', '<')) {
            return $this->buildUrl('extension/module');
        }
        return $this->buildUrl('extension/extension', array('type' => 'module'));
    }

    private function buildUrl($url, $params = array())
    {
        $get_params = http_build_query(
            array_merge(
                $params,
                array('user_token' => $this->session->data['user_token'])
            ));

        $link = $this->url->link($url, $get_params, 'SSL');

        return htmlspecialchars_decode($link);
    }

    public function ajaxSaveGeneralSettings()
    {
        $json = array(
            'result' => array(),
            'errors' => array(),
        );

        $post = @$this->request->post;

        if (!$this->user->hasPermission('modify', $this->module_name)) {
            $json["errors"][] = $this->language->get('error_permission');

        } else if (!$post) {
            $json["errors"][] = 'No $_POST was sent..';
        }

        if (!$json["errors"]) {
            $this->model_setting_setting->editSetting('check_order_status', array(
                'check_order_status_general_settings' => $post,
            ));
            $json["result"][] = $this->language->get('text_success');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', $this->module_name)) {
            $this->session->data['errors']['warning'] = $this->language->get('error_permission');
        }

        return !isset($this->session->data['errors']);
    }

}
