<?php
class ControllerExtensionModuleBulkPrice extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/bulk_price');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		$data['first_use'] = is_null($this->config->get('module_bulk_price_status'));

		$this->model_setting_setting->editSetting('module_bulk_price', array('module_bulk_price_status' => 1));

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/bulk_price', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$filter_data = array(
			'sort'  => 'name',
			'order' => 'ASC'
		);

		// Categories
		$this->load->model('catalog/category');

		$data['categories'] = $this->model_catalog_category->getCategories($filter_data);

		// Manufacturers
		$this->load->model('catalog/manufacturer');

		$data['manufacturers'] = $this->model_catalog_manufacturer->getManufacturers($filter_data);

		// Manufacturers
		$this->load->model('customer/customer_group');

		$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

		$data['user_token'] = $this->session->data['user_token'];

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/bulk_price', $data));
	}

	public function preview() {
		$json = array();

		$this->load->language('extension/module/bulk_price');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			if (!isset($this->request->post['product_type'])) {
				$json['error']['product-type'] = $this->language->get('error_product_type');
			} else {
				if (($this->request->post['product_type'] == 'category' || !empty($this->request->post['both'])) && empty($this->request->post['category'])) {
					$json['error']['category'] = $this->language->get('error_category');
				}

				if (($this->request->post['product_type'] == 'manufacturer' || !empty($this->request->post['both'])) && empty($this->request->post['manufacturer'])) {
					$json['error']['manufacturer'] = $this->language->get('error_manufacturer');
				}

				if ($this->request->post['product_type'] == 'product' && empty($this->request->post['product'])) {
					$json['error']['product'] = $this->language->get('error_product');
				}
			}

			if (!$json) {
				$this->load->model('extension/module/bulk_price');

				$results = $this->model_extension_module_bulk_price->preview($this->request->post);

				$json['products'] = $results;

				$json['success'] = sprintf($this->language->get('text_success_preview'), count($results));
			}
		} else {
			$json['warning'][] = $this->language->get('error_permission');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function price() {
		$json = array();

		$this->load->language('extension/module/bulk_price');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			if (!isset($this->request->post['product_type'])) {
				$json['error']['product-type'] = $this->language->get('error_product_type');
			} else {
				if (($this->request->post['product_type'] == 'category' || !empty($this->request->post['both'])) && empty($this->request->post['category'])) {
					$json['error']['category'] = $this->language->get('error_category');
				}

				if (($this->request->post['product_type'] == 'manufacturer' || !empty($this->request->post['both'])) && empty($this->request->post['manufacturer'])) {
					$json['error']['manufacturer'] = $this->language->get('error_manufacturer');
				}

				if ($this->request->post['product_type'] == 'product' && empty($this->request->post['product'])) {
					$json['error']['product'] = $this->language->get('error_product');
				}
			}

			if (empty($this->request->post['update_type'])) {
				$json['error']['update-type'] = $this->language->get('error_update_type');
			} else {
				if (empty($this->request->post['sign']) || !in_array($this->request->post['sign'], array('+', '-', '*', '/', '='))) {
					$json['error']['sign'] = $this->language->get('error_sign');
				} else {
					if ($this->request->post['update_type'] == 'P') {
						if ($this->request->post['sign'] != '+' && $this->request->post['sign'] != '-') {
							$json['error']['sign'] = $this->language->get('error_sign');
						}
					}
				}
			}

			if (!isset($this->request->post['update_value']) || !is_numeric($this->request->post['update_value'])) {
				$json['error']['update-value'] = $this->language->get('error_update_value');
			}

			if (!$json) {
				$this->load->model('extension/module/bulk_price');

				$result = $this->model_extension_module_bulk_price->price($this->request->post);

				if ($result['applied']) {
					$json['success'] = sprintf($this->language->get('text_success_product'), count($result['applied']), implode(', ', $result['applied']));
				} else {
					$json['warning'][] = $this->language->get('text_no_updated');
				}

				if ($result['ignored']) {
					$json['warning'][] = sprintf($this->language->get('text_ignored_product'), count($result['ignored']), implode(', ', $result['ignored']));
				}

				$this->cache->delete('product');
			}
		} else {
			$json['warning'][] = $this->language->get('error_permission');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function special() {
		$json = array();

		$this->load->language('extension/module/bulk_price');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			if (!isset($this->request->post['product_type'])) {
				$json['error']['product-type'] = $this->language->get('error_product_type');
			} else {
				if (($this->request->post['product_type'] == 'category' || !empty($this->request->post['both'])) && empty($this->request->post['category'])) {
					$json['error']['category'] = $this->language->get('error_category');
				}

				if (($this->request->post['product_type'] == 'manufacturer' || !empty($this->request->post['both'])) && empty($this->request->post['manufacturer'])) {
					$json['error']['manufacturer'] = $this->language->get('error_manufacturer');
				}

				if ($this->request->post['product_type'] == 'product' && empty($this->request->post['product'])) {
					$json['error']['product'] = $this->language->get('error_product');
				}
			}

			if (empty($this->request->post['customer_group'])) {
				$json['error']['customer-group'] = $this->language->get('error_customer_group');
			}

			if (empty($this->request->post['update_type'])) {
				$json['error']['update-type'] = $this->language->get('error_update_type');
			} else {
				if (empty($this->request->post['sign']) || !in_array($this->request->post['sign'], array('+', '-', '*', '/', '='))) {
					$json['error']['sign'] = $this->language->get('error_sign');
				} else {
					if ($this->request->post['update_type'] == 'P') {
						if ($this->request->post['sign'] != '+' && $this->request->post['sign'] != '-') {
							$json['error']['sign'] = $this->language->get('error_sign');
						}
					}
				}
			}

			if (!isset($this->request->post['update_value']) || !is_numeric($this->request->post['update_value'])) {
				$json['error']['update-value'] = $this->language->get('error_update_value');
			}

			if (!$json) {
				$this->load->model('extension/module/bulk_price');

				$result = $this->model_extension_module_bulk_price->special($this->request->post);

				if ($result['applied']) {
					$json['success'] = sprintf($this->language->get('text_success_product'), count($result['applied']), implode(', ', $result['applied']));
				} else {
					$json['warning'][] = $this->language->get('text_no_updated');
				}

				if ($result['ignored']) {
					$json['warning'][] = sprintf($this->language->get('text_ignored_product'), count($result['ignored']), implode(', ', $result['ignored']));
				}

				$this->cache->delete('product');
			}
		} else {
			$json['warning'][] = $this->language->get('error_permission');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function delete() {
		$json = array();

		$this->load->language('extension/module/bulk_price');

		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			if (!isset($this->request->post['product_type'])) {
				$json['error']['product-type'] = $this->language->get('error_product_type');
			} else {
				if (($this->request->post['product_type'] == 'category' || !empty($this->request->post['both'])) && empty($this->request->post['category'])) {
					$json['error']['category'] = $this->language->get('error_category');
				}

				if (($this->request->post['product_type'] == 'manufacturer' || !empty($this->request->post['both'])) && empty($this->request->post['manufacturer'])) {
					$json['error']['manufacturer'] = $this->language->get('error_manufacturer');
				}

				if ($this->request->post['product_type'] == 'product' && empty($this->request->post['product'])) {
					$json['error']['product'] = $this->language->get('error_product');
				}
			}

			if (!$json) {
				$this->load->model('extension/module/bulk_price');

				$this->model_extension_module_bulk_price->delete($this->request->post);

				$json['success'] = $this->language->get('text_done');

				$this->cache->delete('product');
			}
		} else {
			$json['warning'][] = $this->language->get('error_permission');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function adminMenu(&$route = '', &$data = array(), &$output = '') {
		if ($this->user->hasPermission('access', 'extension/module/bulk_price')) {
			$this->load->language('extension/module/bulk_price');
	
			$bulk_price_menu = array(
				'id'       => 'menu-bulk-price',
				'icon'     => 'fa-calculator',
				'name'     => $this->language->get('heading_title_menu'),
				'href'     => $this->url->link('extension/module/bulk_price', 'user_token=' . $this->session->data['user_token'], true),
				'children' => array()
			);
	
			// Mevcut menü öğesini bul ve alt öğesine ekle
			foreach ($data['menus'] as &$menu) {
				if ($menu['id'] == 'menu-moduller') {
					$menu['children'][] = $bulk_price_menu;
					break;
				}
			}
		}
	}
	

	public function install() {
		$this->load->model('setting/event');

		$this->model_setting_event->deleteEventByCode('bulk_price');

        $this->model_setting_event->addEvent('bulk_price', 'admin/view/common/column_left/before', 'extension/module/bulk_price/adminMenu');
	}

	public function uninstall() {
		$this->load->model('setting/event');

		$this->model_setting_event->deleteEventByCode('bulk_price');
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/bulk_price')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}