<?php
class ControllerExtensionDashboardTopProduct extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/dashboard/top_product');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$this->model_setting_setting->editSetting('dashboard_top_product', $this->request->post);



			$this->session->data['success'] = $this->language->get('text_success');



			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true));

		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/dashboard/top_product', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/dashboard/top_product', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true);

		if (isset($this->request->post['dashboard_top_product_width'])) {
			$data['dashboard_top_product_width'] = $this->request->post['dashboard_top_product_width'];
		} else {
			$data['dashboard_top_product_width'] = $this->config->get('dashboard_top_product_width');
		}

		$data['columns'] = array();
		
		for ($i = 3; $i <= 12; $i++) {
			$data['columns'][] = $i;
		}
				
		if (isset($this->request->post['dashboard_top_product_status'])) {
			$data['dashboard_top_product_status'] = $this->request->post['dashboard_top_product_status'];
		} else {
			$data['dashboard_top_product_status'] = $this->config->get('dashboard_top_product_status');
		}

		if (isset($this->request->post['dashboard_top_product_sort_order'])) {
			$data['dashboard_top_product_sort_order'] = $this->request->post['dashboard_top_product_sort_order'];
		} else {
			$data['dashboard_top_product_sort_order'] = $this->config->get('dashboard_top_product_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/dashboard/top_product_form', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/dashboard/top_product')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
	
	public function dashboard() {
		$this->load->language('extension/dashboard/top_product');

		$data['user_token'] = $this->session->data['user_token'];

		// Last 10 customers
		$data['customers'] = array();

		$filter_data = array(
			'start' => 0,
			'limit' => 10
		);

		

		$this->load->model('tool/image');
		$this->load->model('extension/report/product');
		$this->load->model('sale/order');

		$order_total = $this->model_sale_order->getTotalOrders();
		
		$results = $this->model_extension_report_product->gettopproduct($filter_data);
		
		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 50, 50);
			} else {
				$image = $this->model_tool_image->resize('no_image.png', 50, 50);
			}
			$yuzde = (100 / $order_total) * $result['quantity'];
			$data['products'][] = array(
				'rquantity'   => $result['rqty'],
				'quantity'   => $result['quantity'],
				'yuzde'   => $yuzde,
				'image'    => $image,
				'name'   => $result['name'],
				'edit'       => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'])
			);
		}

		return $this->load->view('extension/dashboard/top_product', $data);
	}
}
